#include <stdio.h>
#include <stdlib.h>

#define MAX_N 500000

typedef struct Node {
    int value;
    struct Node* next;
} Node;

Node* createNode(int value) {
    Node* newNode = (Node*)malloc(sizeof(Node));
    newNode->value = value;
    newNode->next = NULL;
    return newNode;
}

typedef struct {
    int size;
    Node** heads;
} Graph;

Graph* createGraph(int size) {
    Graph* graph = (Graph*)malloc(sizeof(Graph));
    graph->size = size;
    graph->heads = (Node**)malloc(size * sizeof(Node*));
    for (int i = 0; i < size; i++) {
        graph->heads[i] = NULL;
    }
    return graph;
}

void addEdge(Graph* graph, int src, int dest) {
    Node* newNode = createNode(dest);
    newNode->next = graph->heads[src];
    graph->heads[src] = newNode;
}

void freeGraph(Graph* graph) {
    for (int i = 0; i < graph->size; i++) {
        Node* current = graph->heads[i];
        while (current != NULL) {
            Node* next = current->next;
            free(current);
            current = next;
        }
    }
    free(graph->heads);
    free(graph);
}

int min(int a, int b) {
    return (a < b) ? a : b;
}

void dfs(Graph* graph, int* platforms, int* changes, int* results, int node, int parent, int strength) {
    int currentChanges = (changes[node] == 1) ? 1 : 0;
    int minJumps = (platforms[node] == 1) ? 0 : MAX_N;

    Node* current = graph->heads[node];
    while (current != NULL) {
        int neighbor = current->value;
        if (neighbor != parent) {
            dfs(graph, platforms, changes, results, neighbor, node, strength);
            minJumps = min(minJumps, results[neighbor] + currentChanges);
        }
        current = current->next;
    }

    results[node] = minJumps;
}

int main() {
    int N;
    scanf("%d", &N);

    Graph* graph = createGraph(N + 1);

    for (int i = 1; i <= N - 1; i++) {
        int Ui, Vi;
        scanf("%d %d", &Ui, &Vi);
        addEdge(graph, Ui, Vi);
        addEdge(graph, Vi, Ui);
    }

    int* platforms = (int*)malloc((N + 1) * sizeof(int));
    int* changes = (int*)malloc((N + 1) * sizeof(int));
    int* results = (int*)malloc((N + 1) * sizeof(int));

    for (int i = 1; i <= N; i++) {
        scanf("%d", &platforms[i]);
    }

    for (int i = 1; i <= N; i++) {
        scanf("%d", &changes[i]);
    }

    dfs(graph, platforms, changes, results, 1, 0, N);

    for (int i = 1; i <= N; i++) {
        if (results[i] >= MAX_N) {
            printf("-1 ");
        } else {
            printf("%d ", results[i]);
        }
    }

    free(platforms);
    free(changes);
    free(results);
    freeGraph(graph);

    return 0;
}